/*
 * GameResultsWidget.java
 *
 * Created on May 19, 2006, 10:19 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package ags.ui.gameSelector;

import ags.ui.*;
import java.util.ArrayList;
import java.util.List;
import ags.game.Game;

/**
 * Framed widget that shows a list of games found and lets the user scroll the list and select a game
 * @author blurry
 */
public class GameResultsWidget extends FrameBasedWidget {
 
    /**
     * List of found results
     */
    List<Game> results;
    /**
     * Currently active (hilighted) item -- index in results list
     */
    int activeItem;
    /**
     * Selected game
     */
    Game selection;
    
    /**
     * Creates a new instance of GameResultsWidget
     * @param a GameSelector application
     */
    public GameResultsWidget(IApplication a) {
        super(a);
        selection = null;
        results = new ArrayList<Game>();
    }

    /**
     * Draws the game results
     */
    public void redrawInside() {
        if (selection == null) {
            String message = "Showing "+results.size()+" result";
            if (results.size() != 1) message+="s";
            if (message.length() < getXSize())
                message += Util.repeat(' ', getXSize()-message.length());
            app.getScreen().drawText(getX(), getY(), message, true);
            int showStart = activeItem - (getYSize()-1)/2;
            showStart = Math.max(0, showStart);
            showStart = Math.min(showStart, Math.max(0,results.size() - getYSize() + 1));
            int currentIndex = showStart;
            for (int i=1; i < getYSize() && currentIndex < results.size(); i++) {
                boolean hilight = (currentIndex == activeItem);
                String name = results.get(currentIndex).getName();
                if (results.get(currentIndex).getType() != 6) name += " (basic)";
//                if (selection == results.get(currentIndex)) name += " <-- LOADING!";
                app.getScreen().drawText(getX(), getY()+i, name, hilight);
                currentIndex++;
            }
        } else {
            app.getScreen().drawText(getX(), getY(), "--> Loading game <--", true);
            app.getScreen().drawText(getX(), getY()+1, selection.getName(), false);
            app.getScreen().drawText(getX(), getY()+2, "Starting Address: "+Integer.toHexString(selection.getStart()), false);
        }
    }

    /**
     * Process arrow and enter keypresses to navigate and/or select items
     * @param b key pressed
     * @return false if keypress not understood
     */
    public boolean handleKeypress(byte b) {
        if (b == Keyboard.KEY_UP) activeItem--;
        else if (b == Keyboard.KEY_DOWN) activeItem++;
        else if (b == Keyboard.KEY_RETURN) executeSelection();
        else if (b == Keyboard.KEY_LEFT) activeItem -= (getYSize()-1)/2;
        else if (b == Keyboard.KEY_RIGHT) activeItem += (getYSize()-1)/2;
        else return false;
        activeItem = Math.max(0, activeItem);
        activeItem = Math.min(activeItem, Math.max(0,results.size()-1));
        app.redraw();
        return true;
    }
    
    /**
     * Signifies that a game has been selected and should be executed
     */
    public void executeSelection() {
        selection = results.get(activeItem);
    }
}